/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import java.util.Objects;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MenuScreenWrapper<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IScreenWrapper {
    private final BaseScreen wrappedGui;
    private boolean drawSlots = true;
    private final TooltipList tooltipList = new TooltipList();

    public MenuScreenWrapper(BaseScreen g, T c, Inventory playerInventory, Component title) {
        super(c, playerInventory, title);
        this.wrappedGui = g;
    }

    public MenuScreenWrapper<T> disableSlotDrawing() {
        this.drawSlots = false;
        return this;
    }

    public void m_7856_() {
        super.m_7856_();
        this.wrappedGui.initGui();
        this.f_97735_ = this.wrappedGui.getX();
        this.f_97736_ = this.wrappedGui.getY();
        this.f_97726_ = this.wrappedGui.width;
        this.f_97727_ = this.wrappedGui.height;
    }

    public boolean m_7043_() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    public boolean m_6375_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
            return true;
        }
        this.wrappedGui.mousePressed(MouseButton.get(button));
        return super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        return super.m_6348_(x, y, button);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        this.wrappedGui.mouseScrolled(scroll);
        return super.m_6050_(x, y, scroll);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.wrappedGui.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.wrappedGui.onBack();
        } else if (this.wrappedGui.onClosedByKey(key)) {
            this.wrappedGui.closeGui(false);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.wrappedGui.keyReleased(key);
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char keyChar, int modifiers) {
        if (this.wrappedGui.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.m_5534_(keyChar, (int)keyChar);
    }

    protected void m_7286_(PoseStack matrixStack, float f, int mx, int my) {
        Theme theme = this.wrappedGui.getTheme();
        GuiHelper.setupDrawing();
        this.m_7333_(matrixStack);
        GuiHelper.setupDrawing();
        this.wrappedGui.draw(matrixStack, theme, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        if (this.drawSlots) {
            GuiHelper.setupDrawing();
            for (Slot slot : this.f_97732_.f_38839_) {
                theme.drawContainerSlot(matrixStack, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, 16, 16);
            }
        }
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(-this.f_97735_), (double)(-this.f_97736_), 0.0);
        GuiHelper.setupDrawing();
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.drawForeground(matrixStack, theme, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        ((Panel)Objects.requireNonNullElse(this.wrappedGui.contextMenu, this.wrappedGui)).addMouseOverText(this.tooltipList);
        if (!this.tooltipList.shouldRender()) {
            Object ingredient;
            Object object = this.wrappedGui.getIngredientUnderMouse();
            if (object instanceof WrappedIngredient && ((WrappedIngredient)object).tooltip && (ingredient = WrappedIngredient.unwrap(object)) instanceof ItemStack && !((ItemStack)ingredient).m_41619_()) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.0, 0.0, (double)this.tooltipList.zOffsetItemTooltip);
                this.m_6057_(matrixStack, (ItemStack)ingredient, mouseX, mouseY);
                matrixStack.m_85849_();
            }
        } else {
            this.tooltipList.render(matrixStack, mouseX, Math.max(mouseY, 18), this.wrappedGui.getScreen().m_85445_(), this.wrappedGui.getScreen().m_85446_(), theme.getFont());
        }
        this.tooltipList.reset();
        if (this.wrappedGui.contextMenu == null) {
            this.m_7025_(matrixStack, mouseX, mouseY);
        }
        matrixStack.m_85849_();
    }

    public void m_7333_(PoseStack matrixStack) {
        if (this.wrappedGui.drawDefaultBackground(matrixStack)) {
            super.m_7333_(matrixStack);
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void m_181908_() {
        super.m_181908_();
        this.wrappedGui.tick();
    }

    @Override
    public BaseScreen getGui() {
        return this.wrappedGui;
    }

    public void m_7861_() {
        this.wrappedGui.onClosed();
        super.m_7861_();
    }
}

